<?php

namespace app\controllers;

use app\models\active\Action;
use app\models\active\Donate;
use Yii;
use yii\filters\AccessControl;
use yii\web\Controller;
use yii\web\Response;
use yii\filters\VerbFilter;
use app\models\User;
use yii\web\Request;
use yii\helpers\Html;
use app\models\WapkassaClass;


class ResultController extends Controller
{
public $enableCsrfValidation = false;

  

    public function actionWapkassa()
    {

        try {

    $wapkassa = new WapkassaClass(Yii::$app->params['wapkassa']['id'], Yii::$app->params['wapkassa']['secret']);


    if ($wapkassa->ping($_POST)) {

        echo $wapkassa->successPing();
    } else {

        $params = $wapkassa->parseRequest($_POST);

        $config = Yii::$app->params['payment'];
        $key = array_search($params['amount'], array_column($config, 'amount'));
        $payment = $config[$key];
        
        $ruby = Action::Week() == 3 ? $payment['ruby'] * 2 : $payment['ruby'];
        
        //$vip = \app\models\active\Action :: Week() == 1 && $params['amount'] > 50000 ? 1 : 0;
        
        $user = User :: findOne($params['add']['user_id']);
        $user->ruby = $user->ruby + $ruby;

        if (Action::Week() == '0' && $ruby >= 5000) {
            $user->free_avatar = $user->free_avatar + 1;
        }
        //$user->vip = $vip;
        $user->save();

        $donate = new Donate();
        $donate->user_id = $user->id;
        $donate->amount = $params['amount'];
        $donate->time = time();
        $donate->save();

        echo $wapkassa->successPayment();
    }
} catch (Exception $e) {

    echo 'Ошибка: ' . $e->getMessage() . PHP_EOL;
}
        
    }
    
    
    public function actionSuccess()
    {
        
        User :: Notice(['status' => 'success', 'title' => 'Рубины успешно куплены']);
        return $this->goHome();
        
    }

   
}